package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterContainerImageResponse(
    containerImage: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerImage
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse = {
    import RegisterContainerImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
      .builder()
      .optionallyWith(containerImage.map(value => value.buildAwsValue()))(
        _.containerImage
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse
      .wrap(buildAwsValue())
}
object RegisterContainerImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse =
      io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse(
        containerImageValue.map(value => value.editable)
      )
    def containerImageValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ContainerImage.ReadOnly]
    def containerImage: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerImage.ReadOnly
    ] = AwsError.unwrapOptionField("containerImage", containerImageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse.ReadOnly {
    override def containerImageValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerImage.ReadOnly
    ] = scala
      .Option(impl.containerImage())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerImage.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
  ): io.github.vigoo.zioaws.lightsail.model.RegisterContainerImageResponse.ReadOnly =
    new Wrapper(impl)
}
