package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait RecordState {
  def unwrap: software.amazon.awssdk.services.lightsail.model.RecordState
}
object RecordState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.RecordState
  ): io.github.vigoo.zioaws.lightsail.model.RecordState = value match {
    case software.amazon.awssdk.services.lightsail.model.RecordState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.RecordState.STARTED =>
      val r = Started
      r
    case software.amazon.awssdk.services.lightsail.model.RecordState.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.lightsail.model.RecordState.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.RecordState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RecordState =
      software.amazon.awssdk.services.lightsail.model.RecordState.UNKNOWN_TO_SDK_VERSION
  }
  case object Started
      extends io.github.vigoo.zioaws.lightsail.model.RecordState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RecordState =
      software.amazon.awssdk.services.lightsail.model.RecordState.STARTED
  }
  case object Succeeded
      extends io.github.vigoo.zioaws.lightsail.model.RecordState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RecordState =
      software.amazon.awssdk.services.lightsail.model.RecordState.SUCCEEDED
  }
  case object Failed
      extends io.github.vigoo.zioaws.lightsail.model.RecordState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RecordState =
      software.amazon.awssdk.services.lightsail.model.RecordState.FAILED
  }
}
