package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  DomainName,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoadBalancerTlsCertificate(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    loadBalancerName: Option[ResourceName] = None,
    isAttached: Option[Boolean] = None,
    status: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateStatus
    ] = None,
    domainName: Option[DomainName] = None,
    domainValidationRecords: Option[Iterable[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
    ]] = None,
    failureReason: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ] = None,
    issuedAt: Option[IsoDate] = None,
    issuer: Option[NonEmptyString] = None,
    keyAlgorithm: Option[NonEmptyString] = None,
    notAfter: Option[IsoDate] = None,
    notBefore: Option[IsoDate] = None,
    renewalSummary: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
    ] = None,
    revocationReason: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ] = None,
    revokedAt: Option[IsoDate] = None,
    serial: Option[NonEmptyString] = None,
    signatureAlgorithm: Option[NonEmptyString] = None,
    subject: Option[NonEmptyString] = None,
    subjectAlternativeNames: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate = {
    import LoadBalancerTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(loadBalancerName.map(value => value: java.lang.String))(
        _.loadBalancerName
      )
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(
        domainValidationRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationRecords)
      .optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason)
      .optionallyWith(issuedAt.map(value => value: Instant))(_.issuedAt)
      .optionallyWith(issuer.map(value => value: java.lang.String))(_.issuer)
      .optionallyWith(keyAlgorithm.map(value => value: java.lang.String))(
        _.keyAlgorithm
      )
      .optionallyWith(notAfter.map(value => value: Instant))(_.notAfter)
      .optionallyWith(notBefore.map(value => value: Instant))(_.notBefore)
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(revocationReason.map(value => value.unwrap))(
        _.revocationReason
      )
      .optionallyWith(revokedAt.map(value => value: Instant))(_.revokedAt)
      .optionallyWith(serial.map(value => value: java.lang.String))(_.serial)
      .optionallyWith(signatureAlgorithm.map(value => value: java.lang.String))(
        _.signatureAlgorithm
      )
      .optionallyWith(subject.map(value => value: java.lang.String))(_.subject)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate =
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        loadBalancerNameValue.map(value => value),
        isAttachedValue.map(value => value),
        statusValue.map(value => value),
        domainNameValue.map(value => value),
        domainValidationRecordsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        failureReasonValue.map(value => value),
        issuedAtValue.map(value => value),
        issuerValue.map(value => value),
        keyAlgorithmValue.map(value => value),
        notAfterValue.map(value => value),
        notBeforeValue.map(value => value),
        renewalSummaryValue.map(value => value.editable),
        revocationReasonValue.map(value => value),
        revokedAtValue.map(value => value),
        serialValue.map(value => value),
        signatureAlgorithmValue.map(value => value),
        subjectValue.map(value => value),
        subjectAlternativeNamesValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def loadBalancerNameValue: Option[ResourceName]
    def isAttachedValue: Option[Boolean]
    def statusValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateStatus
    ]
    def domainNameValue: Option[DomainName]
    def domainValidationRecordsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly
    ]]
    def failureReasonValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ]
    def issuedAtValue: Option[IsoDate]
    def issuerValue: Option[NonEmptyString]
    def keyAlgorithmValue: Option[NonEmptyString]
    def notAfterValue: Option[IsoDate]
    def notBeforeValue: Option[IsoDate]
    def renewalSummaryValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly
    ]
    def revocationReasonValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ]
    def revokedAtValue: Option[IsoDate]
    def serialValue: Option[NonEmptyString]
    def signatureAlgorithmValue: Option[NonEmptyString]
    def subjectValue: Option[NonEmptyString]
    def subjectAlternativeNamesValue: Option[List[String]]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def loadBalancerName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerNameValue)
    def isAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttachedValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def domainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainNameValue)
    def domainValidationRecords: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationRecords",
      domainValidationRecordsValue
    )
    def failureReason: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ] = AwsError.unwrapOptionField("failureReason", failureReasonValue)
    def issuedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("issuedAt", issuedAtValue)
    def issuer: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("issuer", issuerValue)
    def keyAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithmValue)
    def notAfter: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notAfter", notAfterValue)
    def notBefore: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("notBefore", notBeforeValue)
    def renewalSummary: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly
    ] = AwsError.unwrapOptionField("renewalSummary", renewalSummaryValue)
    def revocationReason: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ] = AwsError.unwrapOptionField("revocationReason", revocationReasonValue)
    def revokedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("revokedAt", revokedAtValue)
    def serial: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serial", serialValue)
    def signatureAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithmValue)
    def subject: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subject", subjectValue)
    def subjectAlternativeNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNamesValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
  ) extends io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def loadBalancerNameValue: Option[ResourceName] =
      scala.Option(impl.loadBalancerName()).map(value => value: ResourceName)
    override def isAttachedValue: Option[Boolean] =
      scala.Option(impl.isAttached()).map(value => value: Boolean)
    override def statusValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateStatus
    ] = scala
      .Option(impl.status())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateStatus
          .wrap(value)
      )
    override def domainNameValue: Option[DomainName] =
      scala.Option(impl.domainName()).map(value => value: DomainName)
    override def domainValidationRecordsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly
    ]] = scala
      .Option(impl.domainValidationRecords())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord
            .wrap(item)
        }.toList
      )
    override def failureReasonValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateFailureReason
    ] = scala
      .Option(impl.failureReason())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateFailureReason
          .wrap(value)
      )
    override def issuedAtValue: Option[IsoDate] =
      scala.Option(impl.issuedAt()).map(value => value: IsoDate)
    override def issuerValue: Option[NonEmptyString] =
      scala.Option(impl.issuer()).map(value => value: NonEmptyString)
    override def keyAlgorithmValue: Option[NonEmptyString] =
      scala.Option(impl.keyAlgorithm()).map(value => value: NonEmptyString)
    override def notAfterValue: Option[IsoDate] =
      scala.Option(impl.notAfter()).map(value => value: IsoDate)
    override def notBeforeValue: Option[IsoDate] =
      scala.Option(impl.notBefore()).map(value => value: IsoDate)
    override def renewalSummaryValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly
    ] = scala
      .Option(impl.renewalSummary())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
          .wrap(value)
      )
    override def revocationReasonValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
    ] = scala
      .Option(impl.revocationReason())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRevocationReason
          .wrap(value)
      )
    override def revokedAtValue: Option[IsoDate] =
      scala.Option(impl.revokedAt()).map(value => value: IsoDate)
    override def serialValue: Option[NonEmptyString] =
      scala.Option(impl.serial()).map(value => value: NonEmptyString)
    override def signatureAlgorithmValue: Option[NonEmptyString] = scala
      .Option(impl.signatureAlgorithm())
      .map(value => value: NonEmptyString)
    override def subjectValue: Option[NonEmptyString] =
      scala.Option(impl.subject()).map(value => value: NonEmptyString)
    override def subjectAlternativeNamesValue: Option[List[String]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificate
  ): io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificate.ReadOnly =
    new Wrapper(impl)
}
