package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceEntry(
    sourceName: ResourceName,
    instanceType: NonEmptyString,
    portInfoSource: io.github.vigoo.zioaws.lightsail.model.PortInfoSourceType,
    userData: Option[String] = None,
    availabilityZone: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceEntry = {
    import InstanceEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceEntry
      .builder()
      .sourceName(sourceName: java.lang.String)
      .instanceType(instanceType: java.lang.String)
      .portInfoSource(portInfoSource.unwrap)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .availabilityZone(availabilityZone: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.InstanceEntry.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.InstanceEntry.wrap(buildAwsValue())
}
object InstanceEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.InstanceEntry =
      io.github.vigoo.zioaws.lightsail.model.InstanceEntry(
        sourceNameValue,
        instanceTypeValue,
        portInfoSourceValue,
        userDataValue.map(value => value),
        availabilityZoneValue
      )
    def sourceNameValue: ResourceName
    def instanceTypeValue: NonEmptyString
    def portInfoSourceValue
        : io.github.vigoo.zioaws.lightsail.model.PortInfoSourceType
    def userDataValue: Option[String]
    def availabilityZoneValue: String
    def sourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(sourceNameValue)
    def instanceType: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(instanceTypeValue)
    def portInfoSource: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.PortInfoSourceType
    ] = ZIO.succeed(portInfoSourceValue)
    def userData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userDataValue)
    def availabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZoneValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceEntry
  ) extends io.github.vigoo.zioaws.lightsail.model.InstanceEntry.ReadOnly {
    override def sourceNameValue: ResourceName = impl.sourceName(): ResourceName
    override def instanceTypeValue: NonEmptyString =
      impl.instanceType(): NonEmptyString
    override def portInfoSourceValue
        : io.github.vigoo.zioaws.lightsail.model.PortInfoSourceType =
      io.github.vigoo.zioaws.lightsail.model.PortInfoSourceType
        .wrap(impl.portInfoSource())
    override def userDataValue: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override def availabilityZoneValue: String = impl.availabilityZone(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceEntry
  ): io.github.vigoo.zioaws.lightsail.model.InstanceEntry.ReadOnly =
    new Wrapper(impl)
}
