package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseLogStreamsResponse(
    logStreams: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse = {
    import GetRelationalDatabaseLogStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse
      .builder()
      .optionallyWith(
        logStreams.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logStreams)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseLogStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseLogStreamsResponse(
          logStreamsValue.map(value => value)
        )
    def logStreamsValue: Option[List[String]]
    def logStreams: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logStreams", logStreamsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly {
    override def logStreamsValue: Option[List[String]] = scala
      .Option(impl.logStreams())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly =
    new Wrapper(impl)
}
