package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancersResponse(
    loadBalancers: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.LoadBalancer]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse = {
    import GetLoadBalancersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse
      .builder()
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse
      .wrap(buildAwsValue())
}
object GetLoadBalancersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse =
      io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse(
        loadBalancersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def loadBalancersValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.LoadBalancer.ReadOnly]
    ]
    def nextPageTokenValue: Option[String]
    def loadBalancers: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancer.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancersValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse.ReadOnly {
    override def loadBalancersValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.LoadBalancer.ReadOnly]
    ] = scala
      .Option(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.LoadBalancer.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetLoadBalancersResponse.ReadOnly =
    new Wrapper(impl)
}
