package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.core.BuilderHelper
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Timestamp,
  MetricPeriod,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetInstanceMetricDataRequest(
    instanceName: ResourceName,
    metricName: io.github.vigoo.zioaws.lightsail.model.InstanceMetricName,
    period: MetricPeriod,
    startTime: Timestamp,
    endTime: Timestamp,
    unit: io.github.vigoo.zioaws.lightsail.model.MetricUnit,
    statistics: Iterable[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest = {
    import GetInstanceMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .metricName(metricName.unwrap)
      .period(period: Integer)
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .unit(unit.unwrap)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataRequest
      .wrap(buildAwsValue())
}
object GetInstanceMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataRequest =
      io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataRequest(
        instanceNameValue,
        metricNameValue,
        periodValue,
        startTimeValue,
        endTimeValue,
        unitValue,
        statisticsValue
      )
    def instanceNameValue: ResourceName
    def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.InstanceMetricName
    def periodValue: MetricPeriod
    def startTimeValue: Timestamp
    def endTimeValue: Timestamp
    def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit
    def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
    def metricName: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.InstanceMetricName
    ] = ZIO.succeed(metricNameValue)
    def period: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(periodValue)
    def startTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTimeValue)
    def unit
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.MetricUnit] =
      ZIO.succeed(unitValue)
    def statistics: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.MetricStatistic
    ]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
    override def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.InstanceMetricName =
      io.github.vigoo.zioaws.lightsail.model.InstanceMetricName
        .wrap(impl.metricName())
    override def periodValue: MetricPeriod = impl.period(): MetricPeriod
    override def startTimeValue: Timestamp = impl.startTime(): Timestamp
    override def endTimeValue: Timestamp = impl.endTime(): Timestamp
    override def unitValue: io.github.vigoo.zioaws.lightsail.model.MetricUnit =
      io.github.vigoo.zioaws.lightsail.model.MetricUnit.wrap(impl.unit())
    override def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic] = impl
      .statistics()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.lightsail.model.MetricStatistic.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
