package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetExportSnapshotRecordsRequest(
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest = {
    import GetExportSnapshotRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsRequest
      .wrap(buildAwsValue())
}
object GetExportSnapshotRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetExportSnapshotRecordsRequest(pageTokenValue.map(value => value))
    def pageTokenValue: Option[String]
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsRequest.ReadOnly {
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetExportSnapshotRecordsRequest.ReadOnly =
    new Wrapper(impl)
}
