package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDisksResponse(
    disks: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Disk]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDisksResponse = {
    import GetDisksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDisksResponse
      .builder()
      .optionallyWith(
        disks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.disks)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDisksResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDisksResponse
      .wrap(buildAwsValue())
}
object GetDisksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDisksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetDisksResponse =
      io.github.vigoo.zioaws.lightsail.model.GetDisksResponse(
        disksValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def disksValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly]]
    def nextPageTokenValue: Option[String]
    def disks: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly
    ]] = AwsError.unwrapOptionField("disks", disksValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDisksResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDisksResponse.ReadOnly {
    override def disksValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly]] =
      scala
        .Option(impl.disks())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Disk.wrap(item)
          }.toList
        )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDisksResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetDisksResponse.ReadOnly =
    new Wrapper(impl)
}
