package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDiskSnapshotResponse(
    diskSnapshot: Option[io.github.vigoo.zioaws.lightsail.model.DiskSnapshot] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse = {
    import GetDiskSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse
      .builder()
      .optionallyWith(diskSnapshot.map(value => value.buildAwsValue()))(
        _.diskSnapshot
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse
      .wrap(buildAwsValue())
}
object GetDiskSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetDiskSnapshotResponse(diskSnapshotValue.map(value => value.editable))
    def diskSnapshotValue
        : Option[io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.ReadOnly]
    def diskSnapshot: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.ReadOnly
    ] = AwsError.unwrapOptionField("diskSnapshot", diskSnapshotValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse.ReadOnly {
    override def diskSnapshotValue
        : Option[io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.ReadOnly] =
      scala
        .Option(impl.diskSnapshot())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
