package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerImagesResponse(
    containerImages: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ContainerImage]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse = {
    import GetContainerImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse
      .builder()
      .optionallyWith(
        containerImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerImages)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse
      .wrap(buildAwsValue())
}
object GetContainerImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse(
        containerImagesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def containerImagesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.ContainerImage.ReadOnly]
    ]
    def containerImages: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ContainerImage.ReadOnly
    ]] = AwsError.unwrapOptionField("containerImages", containerImagesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse.ReadOnly {
    override def containerImagesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.ContainerImage.ReadOnly]
    ] = scala
      .Option(impl.containerImages())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.ContainerImage.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerImagesResponse.ReadOnly =
    new Wrapper(impl)
}
