package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetActiveNamesRequest(pageToken: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest = {
    import GetActiveNamesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetActiveNamesRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetActiveNamesRequest
      .wrap(buildAwsValue())
}
object GetActiveNamesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetActiveNamesRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetActiveNamesRequest(pageTokenValue.map(value => value))
    def pageTokenValue: Option[String]
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetActiveNamesRequest.ReadOnly {
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetActiveNamesRequest.ReadOnly =
    new Wrapper(impl)
}
