package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Integer,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiskSnapshot(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    sizeInGb: Option[Integer] = None,
    state: Option[io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState] =
      None,
    progress: Option[String] = None,
    fromDiskName: Option[ResourceName] = None,
    fromDiskArn: Option[NonEmptyString] = None,
    fromInstanceName: Option[ResourceName] = None,
    fromInstanceArn: Option[NonEmptyString] = None,
    isFromAutoSnapshot: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskSnapshot = {
    import DiskSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskSnapshot
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(fromDiskName.map(value => value: java.lang.String))(
        _.fromDiskName
      )
      .optionallyWith(fromDiskArn.map(value => value: java.lang.String))(
        _.fromDiskArn
      )
      .optionallyWith(fromInstanceName.map(value => value: java.lang.String))(
        _.fromInstanceName
      )
      .optionallyWith(fromInstanceArn.map(value => value: java.lang.String))(
        _.fromInstanceArn
      )
      .optionallyWith(
        isFromAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.isFromAutoSnapshot)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.wrap(buildAwsValue())
}
object DiskSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DiskSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DiskSnapshot =
      io.github.vigoo.zioaws.lightsail.model.DiskSnapshot(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        sizeInGbValue.map(value => value),
        stateValue.map(value => value),
        progressValue.map(value => value),
        fromDiskNameValue.map(value => value),
        fromDiskArnValue.map(value => value),
        fromInstanceNameValue.map(value => value),
        fromInstanceArnValue.map(value => value),
        isFromAutoSnapshotValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def sizeInGbValue: Option[Integer]
    def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState]
    def progressValue: Option[String]
    def fromDiskNameValue: Option[ResourceName]
    def fromDiskArnValue: Option[NonEmptyString]
    def fromInstanceNameValue: Option[ResourceName]
    def fromInstanceArnValue: Option[NonEmptyString]
    def isFromAutoSnapshotValue: Option[Boolean]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def sizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def progress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progressValue)
    def fromDiskName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("fromDiskName", fromDiskNameValue)
    def fromDiskArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromDiskArn", fromDiskArnValue)
    def fromInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("fromInstanceName", fromInstanceNameValue)
    def fromInstanceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromInstanceArn", fromInstanceArnValue)
    def isFromAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isFromAutoSnapshot", isFromAutoSnapshotValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshot
  ) extends io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def sizeInGbValue: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
    override def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState] =
      scala
        .Option(impl.state())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState.wrap(value)
        )
    override def progressValue: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override def fromDiskNameValue: Option[ResourceName] =
      scala.Option(impl.fromDiskName()).map(value => value: ResourceName)
    override def fromDiskArnValue: Option[NonEmptyString] =
      scala.Option(impl.fromDiskArn()).map(value => value: NonEmptyString)
    override def fromInstanceNameValue: Option[ResourceName] =
      scala.Option(impl.fromInstanceName()).map(value => value: ResourceName)
    override def fromInstanceArnValue: Option[NonEmptyString] =
      scala.Option(impl.fromInstanceArn()).map(value => value: NonEmptyString)
    override def isFromAutoSnapshotValue: Option[Boolean] =
      scala.Option(impl.isFromAutoSnapshot()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshot
  ): io.github.vigoo.zioaws.lightsail.model.DiskSnapshot.ReadOnly = new Wrapper(
    impl
  )
}
