package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Integer,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDiskFromSnapshotRequest(
    diskName: ResourceName,
    diskSnapshotName: Option[ResourceName] = None,
    availabilityZone: NonEmptyString,
    sizeInGb: Integer,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    addOns: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AddOnRequest]
    ] = None,
    sourceDiskName: Option[String] = None,
    restoreDate: Option[String] = None,
    useLatestRestorableAutoSnapshot: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest = {
    import CreateDiskFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
      .builder()
      .diskName(diskName: java.lang.String)
      .optionallyWith(diskSnapshotName.map(value => value: java.lang.String))(
        _.diskSnapshotName
      )
      .availabilityZone(availabilityZone: java.lang.String)
      .sizeInGb(sizeInGb: java.lang.Integer)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(sourceDiskName.map(value => value: java.lang.String))(
        _.sourceDiskName
      )
      .optionallyWith(restoreDate.map(value => value: java.lang.String))(
        _.restoreDate
      )
      .optionallyWith(
        useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableAutoSnapshot)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotRequest
      .wrap(buildAwsValue())
}
object CreateDiskFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotRequest(
        diskNameValue,
        diskSnapshotNameValue.map(value => value),
        availabilityZoneValue,
        sizeInGbValue,
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        addOnsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        sourceDiskNameValue.map(value => value),
        restoreDateValue.map(value => value),
        useLatestRestorableAutoSnapshotValue.map(value => value)
      )
    def diskNameValue: ResourceName
    def diskSnapshotNameValue: Option[ResourceName]
    def availabilityZoneValue: NonEmptyString
    def sizeInGbValue: Integer
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def addOnsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly]
    ]
    def sourceDiskNameValue: Option[String]
    def restoreDateValue: Option[String]
    def useLatestRestorableAutoSnapshotValue: Option[Boolean]
    def diskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskNameValue)
    def diskSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("diskSnapshotName", diskSnapshotNameValue)
    def availabilityZone: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(availabilityZoneValue)
    def sizeInGb: ZIO[Any, Nothing, Integer] = ZIO.succeed(sizeInGbValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOnsValue)
    def sourceDiskName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceDiskName", sourceDiskNameValue)
    def restoreDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreDate", restoreDateValue)
    def useLatestRestorableAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useLatestRestorableAutoSnapshot",
        useLatestRestorableAutoSnapshotValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotRequest.ReadOnly {
    override def diskNameValue: ResourceName = impl.diskName(): ResourceName
    override def diskSnapshotNameValue: Option[ResourceName] =
      scala.Option(impl.diskSnapshotName()).map(value => value: ResourceName)
    override def availabilityZoneValue: NonEmptyString =
      impl.availabilityZone(): NonEmptyString
    override def sizeInGbValue: Integer = impl.sizeInGb(): Integer
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def addOnsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AddOnRequest.ReadOnly]
    ] = scala
      .Option(impl.addOns())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.AddOnRequest.wrap(item)
        }.toList
      )
    override def sourceDiskNameValue: Option[String] =
      scala.Option(impl.sourceDiskName()).map(value => value: String)
    override def restoreDateValue: Option[String] =
      scala.Option(impl.restoreDate()).map(value => value: String)
    override def useLatestRestorableAutoSnapshotValue: Option[Boolean] = scala
      .Option(impl.useLatestRestorableAutoSnapshot())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateDiskFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
