package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerServiceEndpoint(
    containerName: Option[String] = None,
    containerPort: Option[Integer] = None,
    healthCheck: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint = {
    import ContainerServiceEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
      .builder()
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(containerPort.map(value => value: java.lang.Integer))(
        _.containerPort
      )
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint
      .wrap(buildAwsValue())
}
object ContainerServiceEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint =
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint(
        containerNameValue.map(value => value),
        containerPortValue.map(value => value),
        healthCheckValue.map(value => value.editable)
      )
    def containerNameValue: Option[String]
    def containerPortValue: Option[Integer]
    def healthCheckValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ]
    def containerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerNameValue)
    def containerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("containerPort", containerPortValue)
    def healthCheck: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheckValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
  ) extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint.ReadOnly {
    override def containerNameValue: Option[String] =
      scala.Option(impl.containerName()).map(value => value: String)
    override def containerPortValue: Option[Integer] =
      scala.Option(impl.containerPort()).map(value => value: Integer)
    override def healthCheckValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = scala
      .Option(impl.healthCheck())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint
  ): io.github.vigoo.zioaws.lightsail.model.ContainerServiceEndpoint.ReadOnly =
    new Wrapper(impl)
}
