package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachInstancesToLoadBalancerRequest(
    loadBalancerName: ResourceName,
    instanceNames: Iterable[ResourceName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest = {
    import AttachInstancesToLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .instanceNames(instanceNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerRequest
      .wrap(buildAwsValue())
}
object AttachInstancesToLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerRequest =
      io.github.vigoo.zioaws.lightsail.model
        .AttachInstancesToLoadBalancerRequest(
          loadBalancerNameValue,
          instanceNamesValue
        )
    def loadBalancerNameValue: ResourceName
    def instanceNamesValue: List[ResourceName]
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
    def instanceNames: ZIO[Any, Nothing, List[ResourceName]] =
      ZIO.succeed(instanceNamesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
    override def instanceNamesValue: List[ResourceName] = impl
      .instanceNames()
      .asScala
      .map { item =>
        item: ResourceName
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest
  ): io.github.vigoo.zioaws.lightsail.model.AttachInstancesToLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
