package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName,
    relationalDatabaseSnapshotName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest = {
    import StopRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .optionallyWith(
        relationalDatabaseSnapshotName.map(value => value: java.lang.String)
      )(_.relationalDatabaseSnapshotName)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object StopRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseRequest =
      io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseRequest(
        relationalDatabaseNameValue,
        relationalDatabaseSnapshotNameValue.map(value => value)
      )
    def relationalDatabaseNameValue: ResourceName
    def relationalDatabaseSnapshotNameValue: Option[ResourceName]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def relationalDatabaseSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField(
        "relationalDatabaseSnapshotName",
        relationalDatabaseSnapshotNameValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def relationalDatabaseSnapshotNameValue: Option[ResourceName] =
      scala
        .Option(impl.relationalDatabaseSnapshotName())
        .map(value => value: ResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest
  ): io.github.vigoo.zioaws.lightsail.model.StopRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
