package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopInstanceRequest(
    instanceName: ResourceName,
    force: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StopInstanceRequest = {
    import StopInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StopInstanceRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.StopInstanceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.StopInstanceRequest
      .wrap(buildAwsValue())
}
object StopInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StopInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.StopInstanceRequest =
      io.github.vigoo.zioaws.lightsail.model
        .StopInstanceRequest(instanceNameValue, forceValue.map(value => value))
    def instanceNameValue: ResourceName
    def forceValue: Option[Boolean]
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
    def force: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", forceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StopInstanceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.StopInstanceRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
    override def forceValue: Option[Boolean] =
      scala.Option(impl.force()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StopInstanceRequest
  ): io.github.vigoo.zioaws.lightsail.model.StopInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
