package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceNetworking(
    monthlyTransfer: Option[
      io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer
    ] = None,
    ports: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.InstancePortInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceNetworking = {
    import InstanceNetworking.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceNetworking
      .builder()
      .optionallyWith(monthlyTransfer.map(value => value.buildAwsValue()))(
        _.monthlyTransfer
      )
      .optionallyWith(
        ports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ports)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.InstanceNetworking.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.InstanceNetworking
      .wrap(buildAwsValue())
}
object InstanceNetworking {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceNetworking
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.InstanceNetworking =
      io.github.vigoo.zioaws.lightsail.model.InstanceNetworking(
        monthlyTransferValue.map(value => value.editable),
        portsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def monthlyTransferValue: Option[
      io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer.ReadOnly
    ]
    def portsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.InstancePortInfo.ReadOnly]
    ]
    def monthlyTransfer: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer.ReadOnly
    ] = AwsError.unwrapOptionField("monthlyTransfer", monthlyTransferValue)
    def ports: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.InstancePortInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("ports", portsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceNetworking
  ) extends io.github.vigoo.zioaws.lightsail.model.InstanceNetworking.ReadOnly {
    override def monthlyTransferValue: Option[
      io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer.ReadOnly
    ] = scala
      .Option(impl.monthlyTransfer())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.MonthlyTransfer.wrap(value)
      )
    override def portsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.InstancePortInfo.ReadOnly]
    ] = scala
      .Option(impl.ports())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.InstancePortInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceNetworking
  ): io.github.vigoo.zioaws.lightsail.model.InstanceNetworking.ReadOnly =
    new Wrapper(impl)
}
