package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  Ipv6Address,
  IpAddress,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Instance(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    blueprintId: Option[NonEmptyString] = None,
    blueprintName: Option[NonEmptyString] = None,
    bundleId: Option[NonEmptyString] = None,
    addOns: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.AddOn]] =
      None,
    isStaticIp: Option[Boolean] = None,
    privateIpAddress: Option[IpAddress] = None,
    publicIpAddress: Option[IpAddress] = None,
    ipv6Addresses: Option[Iterable[Ipv6Address]] = None,
    ipAddressType: Option[
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = None,
    hardware: Option[io.github.vigoo.zioaws.lightsail.model.InstanceHardware] =
      None,
    networking: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceNetworking
    ] = None,
    state: Option[io.github.vigoo.zioaws.lightsail.model.InstanceState] = None,
    username: Option[NonEmptyString] = None,
    sshKeyName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Instance
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(blueprintId.map(value => value: java.lang.String))(
        _.blueprintId
      )
      .optionallyWith(blueprintName.map(value => value: java.lang.String))(
        _.blueprintName
      )
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(isStaticIp.map(value => value: java.lang.Boolean))(
        _.isStaticIp
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(publicIpAddress.map(value => value: java.lang.String))(
        _.publicIpAddress
      )
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(hardware.map(value => value.buildAwsValue()))(_.hardware)
      .optionallyWith(networking.map(value => value.buildAwsValue()))(
        _.networking
      )
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(sshKeyName.map(value => value: java.lang.String))(
        _.sshKeyName
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Instance.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Instance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Instance =
      io.github.vigoo.zioaws.lightsail.model.Instance(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        blueprintIdValue.map(value => value),
        blueprintNameValue.map(value => value),
        bundleIdValue.map(value => value),
        addOnsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        isStaticIpValue.map(value => value),
        privateIpAddressValue.map(value => value),
        publicIpAddressValue.map(value => value),
        ipv6AddressesValue.map(value => value),
        ipAddressTypeValue.map(value => value),
        hardwareValue.map(value => value.editable),
        networkingValue.map(value => value.editable),
        stateValue.map(value => value.editable),
        usernameValue.map(value => value),
        sshKeyNameValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def blueprintIdValue: Option[NonEmptyString]
    def blueprintNameValue: Option[NonEmptyString]
    def bundleIdValue: Option[NonEmptyString]
    def addOnsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.AddOn.ReadOnly]]
    def isStaticIpValue: Option[Boolean]
    def privateIpAddressValue: Option[IpAddress]
    def publicIpAddressValue: Option[IpAddress]
    def ipv6AddressesValue: Option[List[Ipv6Address]]
    def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType]
    def hardwareValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceHardware.ReadOnly
    ]
    def networkingValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceNetworking.ReadOnly
    ]
    def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.InstanceState.ReadOnly]
    def usernameValue: Option[NonEmptyString]
    def sshKeyNameValue: Option[ResourceName]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def blueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("blueprintId", blueprintIdValue)
    def blueprintName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("blueprintName", blueprintNameValue)
    def bundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def addOns: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AddOn.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOnsValue)
    def isStaticIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isStaticIp", isStaticIpValue)
    def privateIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddressValue)
    def publicIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddressValue)
    def ipv6Addresses: ZIO[Any, AwsError, List[Ipv6Address]] =
      AwsError.unwrapOptionField("ipv6Addresses", ipv6AddressesValue)
    def ipAddressType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
    def hardware: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceHardware.ReadOnly
    ] = AwsError.unwrapOptionField("hardware", hardwareValue)
    def networking: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceNetworking.ReadOnly
    ] = AwsError.unwrapOptionField("networking", networkingValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceState.ReadOnly
    ] = AwsError.unwrapOptionField("state", stateValue)
    def username: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("username", usernameValue)
    def sshKeyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("sshKeyName", sshKeyNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Instance
  ) extends io.github.vigoo.zioaws.lightsail.model.Instance.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def blueprintIdValue: Option[NonEmptyString] =
      scala.Option(impl.blueprintId()).map(value => value: NonEmptyString)
    override def blueprintNameValue: Option[NonEmptyString] =
      scala.Option(impl.blueprintName()).map(value => value: NonEmptyString)
    override def bundleIdValue: Option[NonEmptyString] =
      scala.Option(impl.bundleId()).map(value => value: NonEmptyString)
    override def addOnsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.AddOn.ReadOnly]] =
      scala
        .Option(impl.addOns())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.AddOn.wrap(item)
          }.toList
        )
    override def isStaticIpValue: Option[Boolean] =
      scala.Option(impl.isStaticIp()).map(value => value: Boolean)
    override def privateIpAddressValue: Option[IpAddress] =
      scala.Option(impl.privateIpAddress()).map(value => value: IpAddress)
    override def publicIpAddressValue: Option[IpAddress] =
      scala.Option(impl.publicIpAddress()).map(value => value: IpAddress)
    override def ipv6AddressesValue: Option[List[Ipv6Address]] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          item: Ipv6Address
        }.toList
      )
    override def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.IpAddressType.wrap(value)
      )
    override def hardwareValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceHardware.ReadOnly
    ] = scala
      .Option(impl.hardware())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.InstanceHardware.wrap(value)
      )
    override def networkingValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceNetworking.ReadOnly
    ] = scala
      .Option(impl.networking())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.InstanceNetworking.wrap(value)
      )
    override def stateValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceState.ReadOnly
    ] = scala
      .Option(impl.state())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.InstanceState.wrap(value)
      )
    override def usernameValue: Option[NonEmptyString] =
      scala.Option(impl.username()).map(value => value: NonEmptyString)
    override def sshKeyNameValue: Option[ResourceName] =
      scala.Option(impl.sshKeyName()).map(value => value: ResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Instance
  ): io.github.vigoo.zioaws.lightsail.model.Instance.ReadOnly = new Wrapper(
    impl
  )
}
