package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImportKeyPairResponse(
    operation: Option[io.github.vigoo.zioaws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse = {
    import ImportKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse
      .wrap(buildAwsValue())
}
object ImportKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse =
      io.github.vigoo.zioaws.lightsail.model
        .ImportKeyPairResponse(operationValue.map(value => value.editable))
    def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    def operation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ] = AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse.ReadOnly {
    override def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse
  ): io.github.vigoo.zioaws.lightsail.model.ImportKeyPairResponse.ReadOnly =
    new Wrapper(impl)
}
