package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{Base64, ResourceName}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ImportKeyPairRequest(
    keyPairName: ResourceName,
    publicKeyBase64: Base64
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest = {
    import ImportKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest
      .builder()
      .keyPairName(keyPairName: java.lang.String)
      .publicKeyBase64(publicKeyBase64: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ImportKeyPairRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ImportKeyPairRequest
      .wrap(buildAwsValue())
}
object ImportKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ImportKeyPairRequest =
      io.github.vigoo.zioaws.lightsail.model
        .ImportKeyPairRequest(keyPairNameValue, publicKeyBase64Value)
    def keyPairNameValue: ResourceName
    def publicKeyBase64Value: Base64
    def keyPairName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(keyPairNameValue)
    def publicKeyBase64: ZIO[Any, Nothing, Base64] =
      ZIO.succeed(publicKeyBase64Value)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.ImportKeyPairRequest.ReadOnly {
    override def keyPairNameValue: ResourceName =
      impl.keyPairName(): ResourceName
    override def publicKeyBase64Value: Base64 = impl.publicKeyBase64(): Base64
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest
  ): io.github.vigoo.zioaws.lightsail.model.ImportKeyPairRequest.ReadOnly =
    new Wrapper(impl)
}
