package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStaticIpResponse(
    staticIp: Option[io.github.vigoo.zioaws.lightsail.model.StaticIp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse = {
    import GetStaticIpResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse
      .builder()
      .optionallyWith(staticIp.map(value => value.buildAwsValue()))(_.staticIp)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse
      .wrap(buildAwsValue())
}
object GetStaticIpResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetStaticIpResponse(staticIpValue.map(value => value.editable))
    def staticIpValue
        : Option[io.github.vigoo.zioaws.lightsail.model.StaticIp.ReadOnly]
    def staticIp: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.StaticIp.ReadOnly
    ] = AwsError.unwrapOptionField("staticIp", staticIpValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse.ReadOnly {
    override def staticIpValue
        : Option[io.github.vigoo.zioaws.lightsail.model.StaticIp.ReadOnly] =
      scala
        .Option(impl.staticIp())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.StaticIp.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetStaticIpResponse.ReadOnly =
    new Wrapper(impl)
}
