package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest = {
    import GetRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseRequest(relationalDatabaseNameValue)
    def relationalDatabaseNameValue: ResourceName
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
