package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOperationsForResourceResponse(
    operations: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.Operation]
    ] = None,
    nextPageCount: Option[String] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse = {
    import GetOperationsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(nextPageCount.map(value => value: java.lang.String))(
        _.nextPageCount
      )
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse
      .wrap(buildAwsValue())
}
object GetOperationsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse =
      io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse(
        operationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageCountValue.map(value => value),
        nextPageTokenValue.map(value => value)
      )
    def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ]
    def nextPageCountValue: Option[String]
    def nextPageTokenValue: Option[String]
    def operations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ]] = AwsError.unwrapOptionField("operations", operationsValue)
    def nextPageCount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageCount", nextPageCountValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse.ReadOnly {
    override def operationsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    ] = scala
      .Option(impl.operations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(item)
        }.toList
      )
    override def nextPageCountValue: Option[String] =
      scala.Option(impl.nextPageCount()).map(value => value: String)
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
