package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetOperationRequest(operationId: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetOperationRequest = {
    import GetOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationRequest
      .builder()
      .operationId(operationId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetOperationRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetOperationRequest
      .wrap(buildAwsValue())
}
object GetOperationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetOperationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetOperationRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetOperationRequest(operationIdValue)
    def operationIdValue: NonEmptyString
    def operationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(operationIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetOperationRequest.ReadOnly {
    override def operationIdValue: NonEmptyString =
      impl.operationId(): NonEmptyString
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetOperationRequest.ReadOnly =
    new Wrapper(impl)
}
