package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancerTlsCertificatesRequest(
    loadBalancerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest = {
    import GetLoadBalancerTlsCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesRequest
      .wrap(buildAwsValue())
}
object GetLoadBalancerTlsCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetLoadBalancerTlsCertificatesRequest(loadBalancerNameValue)
    def loadBalancerNameValue: ResourceName
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerTlsCertificatesRequest.ReadOnly =
    new Wrapper(impl)
}
