package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstancesResponse(
    instances: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.Instance]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstancesResponse = {
    import GetInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse
      .wrap(buildAwsValue())
}
object GetInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse(
        instancesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def instancesValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Instance.ReadOnly]]
    def nextPageTokenValue: Option[String]
    def instances: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instancesValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse.ReadOnly {
    override def instancesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.Instance.ReadOnly]
    ] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.Instance.wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstancesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
