package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceResponse(
    instance: Option[io.github.vigoo.zioaws.lightsail.model.Instance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceResponse = {
    import GetInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceResponse
      .builder()
      .optionallyWith(instance.map(value => value.buildAwsValue()))(_.instance)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse
      .wrap(buildAwsValue())
}
object GetInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetInstanceResponse(instanceValue.map(value => value.editable))
    def instanceValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Instance.ReadOnly]
    def instance: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Instance.ReadOnly
    ] = AwsError.unwrapOptionField("instance", instanceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse.ReadOnly {
    override def instanceValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Instance.ReadOnly] =
      scala
        .Option(impl.instance())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.Instance.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
