package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDistributionsResponse(
    distributions: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.LightsailDistribution]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse = {
    import GetDistributionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse
      .builder()
      .optionallyWith(
        distributions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.distributions)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse
      .wrap(buildAwsValue())
}
object GetDistributionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse(
        distributionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def distributionsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.ReadOnly
    ]]
    def nextPageTokenValue: Option[String]
    def distributions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.ReadOnly
    ]] = AwsError.unwrapOptionField("distributions", distributionsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse.ReadOnly {
    override def distributionsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LightsailDistribution.ReadOnly
    ]] = scala
      .Option(impl.distributions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.LightsailDistribution
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetDistributionsResponse.ReadOnly =
    new Wrapper(impl)
}
