package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.IsoDate
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDistributionLatestCacheResetResponse(
    status: Option[String] = None,
    createTime: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse = {
    import GetDistributionLatestCacheResetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(createTime.map(value => value: Instant))(_.createTime)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse
      .wrap(buildAwsValue())
}
object GetDistributionLatestCacheResetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetDistributionLatestCacheResetResponse(
          statusValue.map(value => value),
          createTimeValue.map(value => value)
        )
    def statusValue: Option[String]
    def createTimeValue: Option[IsoDate]
    def status: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", statusValue)
    def createTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createTime", createTimeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly {
    override def statusValue: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override def createTimeValue: Option[IsoDate] =
      scala.Option(impl.createTime()).map(value => value: IsoDate)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetResponse.ReadOnly =
    new Wrapper(impl)
}
