package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerServicePowersResponse(
    powers: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ContainerServicePower]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse = {
    import GetContainerServicePowersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse
      .builder()
      .optionallyWith(
        powers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.powers)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse
      .wrap(buildAwsValue())
}
object GetContainerServicePowersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse =
      io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse(
        powersValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def powersValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePower.ReadOnly
    ]]
    def powers: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePower.ReadOnly
    ]] = AwsError.unwrapOptionField("powers", powersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse.ReadOnly {
    override def powersValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePower.ReadOnly
    ]] = scala
      .Option(impl.powers())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.ContainerServicePower
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerServicePowersResponse.ReadOnly =
    new Wrapper(impl)
}
