package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCertificatesResponse(
    certificates: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.CertificateSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse = {
    import GetCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
      .builder()
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse
      .wrap(buildAwsValue())
}
object GetCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse =
      io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse(
        certificatesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def certificatesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.CertificateSummary.ReadOnly]
    ]
    def certificates: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.CertificateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificatesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse.ReadOnly {
    override def certificatesValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.CertificateSummary.ReadOnly]
    ] = scala
      .Option(impl.certificates())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.CertificateSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetCertificatesResponse.ReadOnly =
    new Wrapper(impl)
}
