package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  DomainEntryOptionsKeys,
  DomainEntryType,
  DomainName,
  NonEmptyString
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DomainEntry(
    id: Option[NonEmptyString] = None,
    name: Option[DomainName] = None,
    target: Option[String] = None,
    isAlias: Option[Boolean] = None,
    `type`: Option[DomainEntryType] = None,
    options: Option[Map[DomainEntryOptionsKeys, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DomainEntry = {
    import DomainEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DomainEntry
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(target.map(value => value: java.lang.String))(_.target)
      .optionallyWith(isAlias.map(value => value: java.lang.Boolean))(_.isAlias)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(
        options.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.options)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DomainEntry.wrap(buildAwsValue())
}
object DomainEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DomainEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DomainEntry =
      io.github.vigoo.zioaws.lightsail.model.DomainEntry(
        idValue.map(value => value),
        nameValue.map(value => value),
        targetValue.map(value => value),
        isAliasValue.map(value => value),
        typeValue.map(value => value),
        optionsValue.map(value => value)
      )
    def idValue: Option[NonEmptyString]
    def nameValue: Option[DomainName]
    def targetValue: Option[String]
    def isAliasValue: Option[Boolean]
    def typeValue: Option[DomainEntryType]
    def optionsValue: Option[Map[DomainEntryOptionsKeys, String]]
    def id: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", idValue)
    def name: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("name", nameValue)
    def target: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("target", targetValue)
    def isAlias: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAlias", isAliasValue)
    def `type`: ZIO[Any, AwsError, DomainEntryType] =
      AwsError.unwrapOptionField("type", typeValue)
    def options: ZIO[Any, AwsError, Map[DomainEntryOptionsKeys, String]] =
      AwsError.unwrapOptionField("options", optionsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DomainEntry
  ) extends io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly {
    override def idValue: Option[NonEmptyString] =
      scala.Option(impl.id()).map(value => value: NonEmptyString)
    override def nameValue: Option[DomainName] =
      scala.Option(impl.name()).map(value => value: DomainName)
    override def targetValue: Option[String] =
      scala.Option(impl.target()).map(value => value: String)
    override def isAliasValue: Option[Boolean] =
      scala.Option(impl.isAlias()).map(value => value: Boolean)
    override def typeValue: Option[DomainEntryType] =
      scala.Option(impl.`type`()).map(value => value: DomainEntryType)
    override def optionsValue: Option[Map[DomainEntryOptionsKeys, String]] =
      scala
        .Option(impl.options())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: DomainEntryOptionsKeys) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DomainEntry
  ): io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly = new Wrapper(
    impl
  )
}
