package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiskSnapshotInfo(sizeInGb: Option[Integer] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo = {
    import DiskSnapshotInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo
      .builder()
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo
      .wrap(buildAwsValue())
}
object DiskSnapshotInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo =
      io.github.vigoo.zioaws.lightsail.model
        .DiskSnapshotInfo(sizeInGbValue.map(value => value))
    def sizeInGbValue: Option[Integer]
    def sizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo
  ) extends io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo.ReadOnly {
    override def sizeInGbValue: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskSnapshotInfo
  ): io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo.ReadOnly =
    new Wrapper(impl)
}
