package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Integer,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Disk(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    addOns: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.AddOn]] =
      None,
    sizeInGb: Option[Integer] = None,
    isSystemDisk: Option[Boolean] = None,
    iops: Option[Integer] = None,
    path: Option[String] = None,
    state: Option[io.github.vigoo.zioaws.lightsail.model.DiskState] = None,
    attachedTo: Option[ResourceName] = None,
    isAttached: Option[Boolean] = None,
    attachmentState: Option[String] = None,
    gbInUse: Option[Integer] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Disk = {
    import Disk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Disk
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(
        _.sizeInGb
      )
      .optionallyWith(isSystemDisk.map(value => value: java.lang.Boolean))(
        _.isSystemDisk
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(attachedTo.map(value => value: java.lang.String))(
        _.attachedTo
      )
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .optionallyWith(attachmentState.map(value => value: java.lang.String))(
        _.attachmentState
      )
      .optionallyWith(gbInUse.map(value => value: java.lang.Integer))(_.gbInUse)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Disk.wrap(buildAwsValue())
}
object Disk {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Disk] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Disk =
      io.github.vigoo.zioaws.lightsail.model.Disk(
        nameValue.map(value => value),
        arnValue.map(value => value),
        supportCodeValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        addOnsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        sizeInGbValue.map(value => value),
        isSystemDiskValue.map(value => value),
        iopsValue.map(value => value),
        pathValue.map(value => value),
        stateValue.map(value => value),
        attachedToValue.map(value => value),
        isAttachedValue.map(value => value),
        attachmentStateValue.map(value => value),
        gbInUseValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def supportCodeValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def addOnsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.AddOn.ReadOnly]]
    def sizeInGbValue: Option[Integer]
    def isSystemDiskValue: Option[Boolean]
    def iopsValue: Option[Integer]
    def pathValue: Option[String]
    def stateValue: Option[io.github.vigoo.zioaws.lightsail.model.DiskState]
    def attachedToValue: Option[ResourceName]
    def isAttachedValue: Option[Boolean]
    def attachmentStateValue: Option[String]
    def gbInUseValue: Option[Integer]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AddOn.ReadOnly
    ]] = AwsError.unwrapOptionField("addOns", addOnsValue)
    def sizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
    def isSystemDisk: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSystemDisk", isSystemDiskValue)
    def iops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iopsValue)
    def path: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", pathValue)
    def state
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.lightsail.model.DiskState] =
      AwsError.unwrapOptionField("state", stateValue)
    def attachedTo: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("attachedTo", attachedToValue)
    def isAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttachedValue)
    def attachmentState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentState", attachmentStateValue)
    def gbInUse: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("gbInUse", gbInUseValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Disk
  ) extends io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def addOnsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.AddOn.ReadOnly]] =
      scala
        .Option(impl.addOns())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.AddOn.wrap(item)
          }.toList
        )
    override def sizeInGbValue: Option[Integer] =
      scala.Option(impl.sizeInGb()).map(value => value: Integer)
    override def isSystemDiskValue: Option[Boolean] =
      scala.Option(impl.isSystemDisk()).map(value => value: Boolean)
    override def iopsValue: Option[Integer] =
      scala.Option(impl.iops()).map(value => value: Integer)
    override def pathValue: Option[String] =
      scala.Option(impl.path()).map(value => value: String)
    override def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.DiskState] = scala
      .Option(impl.state())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.DiskState.wrap(value)
      )
    override def attachedToValue: Option[ResourceName] =
      scala.Option(impl.attachedTo()).map(value => value: ResourceName)
    override def isAttachedValue: Option[Boolean] =
      scala.Option(impl.isAttached()).map(value => value: Boolean)
    override def attachmentStateValue: Option[String] =
      scala.Option(impl.attachmentState()).map(value => value: String)
    override def gbInUseValue: Option[Integer] =
      scala.Option(impl.gbInUse()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Disk
  ): io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly = new Wrapper(impl)
}
