package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DestinationInfo(
    id: Option[NonEmptyString] = None,
    service: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DestinationInfo = {
    import DestinationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DestinationInfo
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(service.map(value => value: java.lang.String))(_.service)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DestinationInfo.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DestinationInfo.wrap(buildAwsValue())
}
object DestinationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DestinationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DestinationInfo =
      io.github.vigoo.zioaws.lightsail.model.DestinationInfo(
        idValue.map(value => value),
        serviceValue.map(value => value)
      )
    def idValue: Option[NonEmptyString]
    def serviceValue: Option[NonEmptyString]
    def id: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", idValue)
    def service: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("service", serviceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DestinationInfo
  ) extends io.github.vigoo.zioaws.lightsail.model.DestinationInfo.ReadOnly {
    override def idValue: Option[NonEmptyString] =
      scala.Option(impl.id()).map(value => value: NonEmptyString)
    override def serviceValue: Option[NonEmptyString] =
      scala.Option(impl.service()).map(value => value: NonEmptyString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DestinationInfo
  ): io.github.vigoo.zioaws.lightsail.model.DestinationInfo.ReadOnly =
    new Wrapper(impl)
}
