package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteInstanceSnapshotRequest(
    instanceSnapshotName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest = {
    import DeleteInstanceSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest
      .builder()
      .instanceSnapshotName(instanceSnapshotName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotRequest
      .wrap(buildAwsValue())
}
object DeleteInstanceSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteInstanceSnapshotRequest(instanceSnapshotNameValue)
    def instanceSnapshotNameValue: ResourceName
    def instanceSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceSnapshotNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotRequest.ReadOnly {
    override def instanceSnapshotNameValue: ResourceName =
      impl.instanceSnapshotName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteInstanceSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
