package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDomainEntryResponse(
    operation: Option[io.github.vigoo.zioaws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse = {
    import CreateDomainEntryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse
      .wrap(buildAwsValue())
}
object CreateDomainEntryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse =
      io.github.vigoo.zioaws.lightsail.model
        .CreateDomainEntryResponse(operationValue.map(value => value.editable))
    def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    def operation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ] = AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse.ReadOnly {
    override def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse
  ): io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryResponse.ReadOnly =
    new Wrapper(impl)
}
