package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContainerServiceDeploymentResponse(
    containerService: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerService
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse = {
    import CreateContainerServiceDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse
      .builder()
      .optionallyWith(containerService.map(value => value.buildAwsValue()))(
        _.containerService
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse
      .wrap(buildAwsValue())
}
object CreateContainerServiceDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse =
      io.github.vigoo.zioaws.lightsail.model
        .CreateContainerServiceDeploymentResponse(
          containerServiceValue.map(value => value.editable)
        )
    def containerServiceValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly
    ]
    def containerService: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly
    ] = AwsError.unwrapOptionField("containerService", containerServiceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly {
    override def containerServiceValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly
    ] = scala
      .Option(impl.containerService())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerService.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse
  ): io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceDeploymentResponse.ReadOnly =
    new Wrapper(impl)
}
