package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContainerServicePower(
    powerId: Option[String] = None,
    price: Option[Float] = None,
    cpuCount: Option[Float] = None,
    ramSizeInGb: Option[Float] = None,
    name: Option[String] = None,
    isActive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerServicePower = {
    import ContainerServicePower.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServicePower
      .builder()
      .optionallyWith(powerId.map(value => value: java.lang.String))(_.powerId)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(cpuCount.map(value => value: java.lang.Float))(_.cpuCount)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContainerServicePower.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContainerServicePower
      .wrap(buildAwsValue())
}
object ContainerServicePower {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerServicePower
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ContainerServicePower =
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePower(
        powerIdValue.map(value => value),
        priceValue.map(value => value),
        cpuCountValue.map(value => value),
        ramSizeInGbValue.map(value => value),
        nameValue.map(value => value),
        isActiveValue.map(value => value)
      )
    def powerIdValue: Option[String]
    def priceValue: Option[Float]
    def cpuCountValue: Option[Float]
    def ramSizeInGbValue: Option[Float]
    def nameValue: Option[String]
    def isActiveValue: Option[Boolean]
    def powerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("powerId", powerIdValue)
    def price: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", priceValue)
    def cpuCount: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def ramSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def isActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActiveValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServicePower
  ) extends io.github.vigoo.zioaws.lightsail.model.ContainerServicePower.ReadOnly {
    override def powerIdValue: Option[String] =
      scala.Option(impl.powerId()).map(value => value: String)
    override def priceValue: Option[Float] =
      scala.Option(impl.price()).map(value => value: Float)
    override def cpuCountValue: Option[Float] =
      scala.Option(impl.cpuCount()).map(value => value: Float)
    override def ramSizeInGbValue: Option[Float] =
      scala.Option(impl.ramSizeInGb()).map(value => value: Float)
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def isActiveValue: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerServicePower
  ): io.github.vigoo.zioaws.lightsail.model.ContainerServicePower.ReadOnly =
    new Wrapper(impl)
}
