package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  ResourceName,
  NonEmptyString
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ContactMethod(
    contactEndpoint: Option[NonEmptyString] = None,
    status: Option[io.github.vigoo.zioaws.lightsail.model.ContactMethodStatus] =
      None,
    protocol: Option[io.github.vigoo.zioaws.lightsail.model.ContactProtocol] =
      None,
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    supportCode: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContactMethod = {
    import ContactMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContactMethod
      .builder()
      .optionallyWith(contactEndpoint.map(value => value: java.lang.String))(
        _.contactEndpoint
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContactMethod.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContactMethod.wrap(buildAwsValue())
}
object ContactMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContactMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ContactMethod =
      io.github.vigoo.zioaws.lightsail.model.ContactMethod(
        contactEndpointValue.map(value => value),
        statusValue.map(value => value),
        protocolValue.map(value => value),
        nameValue.map(value => value),
        arnValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        supportCodeValue.map(value => value)
      )
    def contactEndpointValue: Option[NonEmptyString]
    def statusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ContactMethodStatus]
    def protocolValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def supportCodeValue: Option[String]
    def contactEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("contactEndpoint", contactEndpointValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContactMethodStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def protocol: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContactProtocol
    ] = AwsError.unwrapOptionField("protocol", protocolValue)
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContactMethod
  ) extends io.github.vigoo.zioaws.lightsail.model.ContactMethod.ReadOnly {
    override def contactEndpointValue: Option[NonEmptyString] =
      scala.Option(impl.contactEndpoint()).map(value => value: NonEmptyString)
    override def statusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ContactMethodStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.ContactMethodStatus.wrap(value)
        )
    override def protocolValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ContactProtocol] = scala
      .Option(impl.protocol())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContactProtocol.wrap(value)
      )
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContactMethod
  ): io.github.vigoo.zioaws.lightsail.model.ContactMethod.ReadOnly =
    new Wrapper(impl)
}
