package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  DomainName,
  CertificateName,
  NonEmptyString
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CertificateSummary(
    certificateArn: Option[NonEmptyString] = None,
    certificateName: Option[CertificateName] = None,
    domainName: Option[DomainName] = None,
    certificateDetail: Option[
      io.github.vigoo.zioaws.lightsail.model.Certificate
    ] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CertificateSummary = {
    import CertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CertificateSummary
      .builder()
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(certificateName.map(value => value: java.lang.String))(
        _.certificateName
      )
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(certificateDetail.map(value => value.buildAwsValue()))(
        _.certificateDetail
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CertificateSummary.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CertificateSummary
      .wrap(buildAwsValue())
}
object CertificateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CertificateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CertificateSummary =
      io.github.vigoo.zioaws.lightsail.model.CertificateSummary(
        certificateArnValue.map(value => value),
        certificateNameValue.map(value => value),
        domainNameValue.map(value => value),
        certificateDetailValue.map(value => value.editable),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def certificateArnValue: Option[NonEmptyString]
    def certificateNameValue: Option[CertificateName]
    def domainNameValue: Option[DomainName]
    def certificateDetailValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Certificate.ReadOnly]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def certificateArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("certificateArn", certificateArnValue)
    def certificateName: ZIO[Any, AwsError, CertificateName] =
      AwsError.unwrapOptionField("certificateName", certificateNameValue)
    def domainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainNameValue)
    def certificateDetail: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Certificate.ReadOnly
    ] = AwsError.unwrapOptionField("certificateDetail", certificateDetailValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CertificateSummary
  ) extends io.github.vigoo.zioaws.lightsail.model.CertificateSummary.ReadOnly {
    override def certificateArnValue: Option[NonEmptyString] =
      scala.Option(impl.certificateArn()).map(value => value: NonEmptyString)
    override def certificateNameValue: Option[CertificateName] =
      scala.Option(impl.certificateName()).map(value => value: CertificateName)
    override def domainNameValue: Option[DomainName] =
      scala.Option(impl.domainName()).map(value => value: DomainName)
    override def certificateDetailValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Certificate.ReadOnly] =
      scala
        .Option(impl.certificateDetail())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.Certificate.wrap(value)
        )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CertificateSummary
  ): io.github.vigoo.zioaws.lightsail.model.CertificateSummary.ReadOnly =
    new Wrapper(impl)
}
