package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  Integer
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Bundle(
    price: Option[Float] = None,
    cpuCount: Option[Integer] = None,
    diskSizeInGb: Option[Integer] = None,
    bundleId: Option[NonEmptyString] = None,
    instanceType: Option[String] = None,
    isActive: Option[Boolean] = None,
    name: Option[String] = None,
    power: Option[Integer] = None,
    ramSizeInGb: Option[Float] = None,
    transferPerMonthInGb: Option[Integer] = None,
    supportedPlatforms: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.InstancePlatform]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Bundle = {
    import Bundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Bundle
      .builder()
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(cpuCount.map(value => value: java.lang.Integer))(
        _.cpuCount
      )
      .optionallyWith(diskSizeInGb.map(value => value: java.lang.Integer))(
        _.diskSizeInGb
      )
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(power.map(value => value: java.lang.Integer))(_.power)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .optionallyWith(
        transferPerMonthInGb.map(value => value: java.lang.Integer)
      )(_.transferPerMonthInGb)
      .optionallyWith(
        supportedPlatforms.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedPlatformsWithStrings)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Bundle.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Bundle.wrap(buildAwsValue())
}
object Bundle {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Bundle] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Bundle =
      io.github.vigoo.zioaws.lightsail.model.Bundle(
        priceValue.map(value => value),
        cpuCountValue.map(value => value),
        diskSizeInGbValue.map(value => value),
        bundleIdValue.map(value => value),
        instanceTypeValue.map(value => value),
        isActiveValue.map(value => value),
        nameValue.map(value => value),
        powerValue.map(value => value),
        ramSizeInGbValue.map(value => value),
        transferPerMonthInGbValue.map(value => value),
        supportedPlatformsValue.map(value => value)
      )
    def priceValue: Option[Float]
    def cpuCountValue: Option[Integer]
    def diskSizeInGbValue: Option[Integer]
    def bundleIdValue: Option[NonEmptyString]
    def instanceTypeValue: Option[String]
    def isActiveValue: Option[Boolean]
    def nameValue: Option[String]
    def powerValue: Option[Integer]
    def ramSizeInGbValue: Option[Float]
    def transferPerMonthInGbValue: Option[Integer]
    def supportedPlatformsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.InstancePlatform]]
    def price: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", priceValue)
    def cpuCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def diskSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGbValue)
    def bundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def instanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceTypeValue)
    def isActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActiveValue)
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def power: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("power", powerValue)
    def ramSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
    def transferPerMonthInGb: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("transferPerMonthInGb", transferPerMonthInGbValue)
    def supportedPlatforms: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.InstancePlatform
    ]] =
      AwsError.unwrapOptionField("supportedPlatforms", supportedPlatformsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Bundle
  ) extends io.github.vigoo.zioaws.lightsail.model.Bundle.ReadOnly {
    override def priceValue: Option[Float] =
      scala.Option(impl.price()).map(value => value: Float)
    override def cpuCountValue: Option[Integer] =
      scala.Option(impl.cpuCount()).map(value => value: Integer)
    override def diskSizeInGbValue: Option[Integer] =
      scala.Option(impl.diskSizeInGb()).map(value => value: Integer)
    override def bundleIdValue: Option[NonEmptyString] =
      scala.Option(impl.bundleId()).map(value => value: NonEmptyString)
    override def instanceTypeValue: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override def isActiveValue: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def powerValue: Option[Integer] =
      scala.Option(impl.power()).map(value => value: Integer)
    override def ramSizeInGbValue: Option[Float] =
      scala.Option(impl.ramSizeInGb()).map(value => value: Float)
    override def transferPerMonthInGbValue: Option[Integer] =
      scala.Option(impl.transferPerMonthInGb()).map(value => value: Integer)
    override def supportedPlatformsValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.InstancePlatform]
    ] = scala
      .Option(impl.supportedPlatforms())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.InstancePlatform.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Bundle
  ): io.github.vigoo.zioaws.lightsail.model.Bundle.ReadOnly = new Wrapper(impl)
}
