package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  Integer,
  NonEmptyString
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BucketBundle(
    bundleId: Option[NonEmptyString] = None,
    name: Option[NonEmptyString] = None,
    price: Option[Float] = None,
    storagePerMonthInGb: Option[Integer] = None,
    transferPerMonthInGb: Option[Integer] = None,
    isActive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.BucketBundle = {
    import BucketBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketBundle
      .builder()
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(
        storagePerMonthInGb.map(value => value: java.lang.Integer)
      )(_.storagePerMonthInGb)
      .optionallyWith(
        transferPerMonthInGb.map(value => value: java.lang.Integer)
      )(_.transferPerMonthInGb)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.BucketBundle.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.BucketBundle.wrap(buildAwsValue())
}
object BucketBundle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.BucketBundle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.BucketBundle =
      io.github.vigoo.zioaws.lightsail.model.BucketBundle(
        bundleIdValue.map(value => value),
        nameValue.map(value => value),
        priceValue.map(value => value),
        storagePerMonthInGbValue.map(value => value),
        transferPerMonthInGbValue.map(value => value),
        isActiveValue.map(value => value)
      )
    def bundleIdValue: Option[NonEmptyString]
    def nameValue: Option[NonEmptyString]
    def priceValue: Option[Float]
    def storagePerMonthInGbValue: Option[Integer]
    def transferPerMonthInGbValue: Option[Integer]
    def isActiveValue: Option[Boolean]
    def bundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def name: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", nameValue)
    def price: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", priceValue)
    def storagePerMonthInGb: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("storagePerMonthInGb", storagePerMonthInGbValue)
    def transferPerMonthInGb: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("transferPerMonthInGb", transferPerMonthInGbValue)
    def isActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActiveValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.BucketBundle
  ) extends io.github.vigoo.zioaws.lightsail.model.BucketBundle.ReadOnly {
    override def bundleIdValue: Option[NonEmptyString] =
      scala.Option(impl.bundleId()).map(value => value: NonEmptyString)
    override def nameValue: Option[NonEmptyString] =
      scala.Option(impl.name()).map(value => value: NonEmptyString)
    override def priceValue: Option[Float] =
      scala.Option(impl.price()).map(value => value: Float)
    override def storagePerMonthInGbValue: Option[Integer] =
      scala.Option(impl.storagePerMonthInGb()).map(value => value: Integer)
    override def transferPerMonthInGbValue: Option[Integer] =
      scala.Option(impl.transferPerMonthInGb()).map(value => value: Integer)
    override def isActiveValue: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.BucketBundle
  ): io.github.vigoo.zioaws.lightsail.model.BucketBundle.ReadOnly = new Wrapper(
    impl
  )
}
