package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait BlueprintType {
  def unwrap: software.amazon.awssdk.services.lightsail.model.BlueprintType
}
object BlueprintType {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.BlueprintType
  ): io.github.vigoo.zioaws.lightsail.model.BlueprintType = value match {
    case software.amazon.awssdk.services.lightsail.model.BlueprintType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.BlueprintType.OS =>
      val r = os
      r
    case software.amazon.awssdk.services.lightsail.model.BlueprintType.APP =>
      val r = app
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.BlueprintType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BlueprintType =
      software.amazon.awssdk.services.lightsail.model.BlueprintType.UNKNOWN_TO_SDK_VERSION
  }
  case object os extends io.github.vigoo.zioaws.lightsail.model.BlueprintType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BlueprintType =
      software.amazon.awssdk.services.lightsail.model.BlueprintType.OS
  }
  case object app extends io.github.vigoo.zioaws.lightsail.model.BlueprintType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.BlueprintType =
      software.amazon.awssdk.services.lightsail.model.BlueprintType.APP
  }
}
