package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AttachDiskRequest(
    diskName: ResourceName,
    instanceName: ResourceName,
    diskPath: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AttachDiskRequest = {
    import AttachDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachDiskRequest
      .builder()
      .diskName(diskName: java.lang.String)
      .instanceName(instanceName: java.lang.String)
      .diskPath(diskPath: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AttachDiskRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AttachDiskRequest
      .wrap(buildAwsValue())
}
object AttachDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AttachDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AttachDiskRequest =
      io.github.vigoo.zioaws.lightsail.model
        .AttachDiskRequest(diskNameValue, instanceNameValue, diskPathValue)
    def diskNameValue: ResourceName
    def instanceNameValue: ResourceName
    def diskPathValue: NonEmptyString
    def diskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskNameValue)
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
    def diskPath: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(diskPathValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AttachDiskRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.AttachDiskRequest.ReadOnly {
    override def diskNameValue: ResourceName = impl.diskName(): ResourceName
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
    override def diskPathValue: NonEmptyString = impl.diskPath(): NonEmptyString
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AttachDiskRequest
  ): io.github.vigoo.zioaws.lightsail.model.AttachDiskRequest.ReadOnly =
    new Wrapper(impl)
}
