package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  Integer,
  MetricPeriod,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Alarm(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    supportCode: Option[String] = None,
    monitoredResourceInfo: Option[
      io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo
    ] = None,
    comparisonOperator: Option[
      io.github.vigoo.zioaws.lightsail.model.ComparisonOperator
    ] = None,
    evaluationPeriods: Option[Integer] = None,
    period: Option[MetricPeriod] = None,
    threshold: Option[Double] = None,
    datapointsToAlarm: Option[Integer] = None,
    treatMissingData: Option[
      io.github.vigoo.zioaws.lightsail.model.TreatMissingData
    ] = None,
    statistic: Option[io.github.vigoo.zioaws.lightsail.model.MetricStatistic] =
      None,
    metricName: Option[io.github.vigoo.zioaws.lightsail.model.MetricName] =
      None,
    state: Option[io.github.vigoo.zioaws.lightsail.model.AlarmState] = None,
    unit: Option[io.github.vigoo.zioaws.lightsail.model.MetricUnit] = None,
    contactProtocols: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]
    ] = None,
    notificationTriggers: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AlarmState]
    ] = None,
    notificationEnabled: Option[Boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Alarm = {
    import Alarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Alarm
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(
        monitoredResourceInfo.map(value => value.buildAwsValue())
      )(_.monitoredResourceInfo)
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(evaluationPeriods.map(value => value: java.lang.Integer))(
        _.evaluationPeriods
      )
      .optionallyWith(period.map(value => value: java.lang.Integer))(_.period)
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .optionallyWith(datapointsToAlarm.map(value => value: java.lang.Integer))(
        _.datapointsToAlarm
      )
      .optionallyWith(treatMissingData.map(value => value.unwrap))(
        _.treatMissingData
      )
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        contactProtocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.contactProtocolsWithStrings)
      .optionallyWith(
        notificationTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationTriggersWithStrings)
      .optionallyWith(
        notificationEnabled.map(value => value: java.lang.Boolean)
      )(_.notificationEnabled)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.Alarm.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.Alarm.wrap(buildAwsValue())
}
object Alarm {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Alarm] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.Alarm =
      io.github.vigoo.zioaws.lightsail.model.Alarm(
        nameValue.map(value => value),
        arnValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        supportCodeValue.map(value => value),
        monitoredResourceInfoValue.map(value => value.editable),
        comparisonOperatorValue.map(value => value),
        evaluationPeriodsValue.map(value => value),
        periodValue.map(value => value),
        thresholdValue.map(value => value),
        datapointsToAlarmValue.map(value => value),
        treatMissingDataValue.map(value => value),
        statisticValue.map(value => value),
        metricNameValue.map(value => value),
        stateValue.map(value => value),
        unitValue.map(value => value),
        contactProtocolsValue.map(value => value),
        notificationTriggersValue.map(value => value),
        notificationEnabledValue.map(value => value)
      )
    def nameValue: Option[ResourceName]
    def arnValue: Option[NonEmptyString]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def supportCodeValue: Option[String]
    def monitoredResourceInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo.ReadOnly
    ]
    def comparisonOperatorValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ComparisonOperator]
    def evaluationPeriodsValue: Option[Integer]
    def periodValue: Option[MetricPeriod]
    def thresholdValue: Option[Double]
    def datapointsToAlarmValue: Option[Integer]
    def treatMissingDataValue
        : Option[io.github.vigoo.zioaws.lightsail.model.TreatMissingData]
    def statisticValue
        : Option[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
    def metricNameValue
        : Option[io.github.vigoo.zioaws.lightsail.model.MetricName]
    def stateValue: Option[io.github.vigoo.zioaws.lightsail.model.AlarmState]
    def unitValue: Option[io.github.vigoo.zioaws.lightsail.model.MetricUnit]
    def contactProtocolsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]]
    def notificationTriggersValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.AlarmState]]
    def notificationEnabledValue: Option[Boolean]
    def name: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def supportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def monitoredResourceInfo: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoredResourceInfo",
      monitoredResourceInfoValue
    )
    def comparisonOperator: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ComparisonOperator
    ] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperatorValue)
    def evaluationPeriods: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriodsValue)
    def period: ZIO[Any, AwsError, MetricPeriod] =
      AwsError.unwrapOptionField("period", periodValue)
    def threshold: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("threshold", thresholdValue)
    def datapointsToAlarm: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarmValue)
    def treatMissingData: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.TreatMissingData
    ] = AwsError.unwrapOptionField("treatMissingData", treatMissingDataValue)
    def statistic: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.MetricStatistic
    ] = AwsError.unwrapOptionField("statistic", statisticValue)
    def metricName: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.MetricName
    ] = AwsError.unwrapOptionField("metricName", metricNameValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AlarmState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.MetricUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
    def contactProtocols: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ContactProtocol
    ]] = AwsError.unwrapOptionField("contactProtocols", contactProtocolsValue)
    def notificationTriggers: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AlarmState
    ]] = AwsError.unwrapOptionField(
      "notificationTriggers",
      notificationTriggersValue
    )
    def notificationEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("notificationEnabled", notificationEnabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Alarm
  ) extends io.github.vigoo.zioaws.lightsail.model.Alarm.ReadOnly {
    override def nameValue: Option[ResourceName] =
      scala.Option(impl.name()).map(value => value: ResourceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def supportCodeValue: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override def monitoredResourceInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo.ReadOnly
    ] = scala
      .Option(impl.monitoredResourceInfo())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.MonitoredResourceInfo.wrap(value)
      )
    override def comparisonOperatorValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ComparisonOperator] =
      scala
        .Option(impl.comparisonOperator())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.ComparisonOperator.wrap(value)
        )
    override def evaluationPeriodsValue: Option[Integer] =
      scala.Option(impl.evaluationPeriods()).map(value => value: Integer)
    override def periodValue: Option[MetricPeriod] =
      scala.Option(impl.period()).map(value => value: MetricPeriod)
    override def thresholdValue: Option[Double] =
      scala.Option(impl.threshold()).map(value => value: Double)
    override def datapointsToAlarmValue: Option[Integer] =
      scala.Option(impl.datapointsToAlarm()).map(value => value: Integer)
    override def treatMissingDataValue
        : Option[io.github.vigoo.zioaws.lightsail.model.TreatMissingData] =
      scala
        .Option(impl.treatMissingData())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.TreatMissingData.wrap(value)
        )
    override def statisticValue
        : Option[io.github.vigoo.zioaws.lightsail.model.MetricStatistic] = scala
      .Option(impl.statistic())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.MetricStatistic.wrap(value)
      )
    override def metricNameValue
        : Option[io.github.vigoo.zioaws.lightsail.model.MetricName] = scala
      .Option(impl.metricName())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.MetricName.wrap(value)
      )
    override def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AlarmState] = scala
      .Option(impl.state())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.AlarmState.wrap(value)
      )
    override def unitValue
        : Option[io.github.vigoo.zioaws.lightsail.model.MetricUnit] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.MetricUnit.wrap(value)
      )
    override def contactProtocolsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.ContactProtocol]] =
      scala
        .Option(impl.contactProtocols())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.ContactProtocol.wrap(item)
          }.toList
        )
    override def notificationTriggersValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.AlarmState]] =
      scala
        .Option(impl.notificationTriggers())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.AlarmState.wrap(item)
          }.toList
        )
    override def notificationEnabledValue: Option[Boolean] =
      scala.Option(impl.notificationEnabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Alarm
  ): io.github.vigoo.zioaws.lightsail.model.Alarm.ReadOnly = new Wrapper(impl)
}
