package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait AccessDirection {
  def unwrap: software.amazon.awssdk.services.lightsail.model.AccessDirection
}
object AccessDirection {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.AccessDirection
  ): io.github.vigoo.zioaws.lightsail.model.AccessDirection = value match {
    case software.amazon.awssdk.services.lightsail.model.AccessDirection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AccessDirection.INBOUND =>
      val r = inbound
      r
    case software.amazon.awssdk.services.lightsail.model.AccessDirection.OUTBOUND =>
      val r = outbound
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.AccessDirection {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccessDirection =
      software.amazon.awssdk.services.lightsail.model.AccessDirection.UNKNOWN_TO_SDK_VERSION
  }
  case object inbound
      extends io.github.vigoo.zioaws.lightsail.model.AccessDirection {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccessDirection =
      software.amazon.awssdk.services.lightsail.model.AccessDirection.INBOUND
  }
  case object outbound
      extends io.github.vigoo.zioaws.lightsail.model.AccessDirection {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.AccessDirection =
      software.amazon.awssdk.services.lightsail.model.AccessDirection.OUTBOUND
  }
}
