package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  ResourceArn,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceName: ResourceName,
    resourceArn: Option[ResourceArn] = None,
    tags: Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.TagResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.TagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.TagResourceRequest
      .wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.TagResourceRequest =
      io.github.vigoo.zioaws.lightsail.model.TagResourceRequest(
        resourceNameValue,
        resourceArnValue.map(value => value),
        tagsValue.map { item =>
          item.editable
        }
      )
    def resourceNameValue: ResourceName
    def resourceArnValue: Option[ResourceArn]
    def tagsValue: List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]
    def resourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceNameValue)
    def resourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def tags: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.TagResourceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.TagResourceRequest.ReadOnly {
    override def resourceNameValue: ResourceName =
      impl.resourceName(): ResourceName
    override def resourceArnValue: Option[ResourceArn] =
      scala.Option(impl.resourceArn()).map(value => value: ResourceArn)
    override def tagsValue
        : List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.TagResourceRequest
  ): io.github.vigoo.zioaws.lightsail.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
